//
//  DLSourceListRegistry.h
//  DL2Harness
//
//  Created by Michael Clark on Tue Jun 22 2004.
//  Copyright (c) 2004 __MyCompanyName__. All rights reserved.
//

#import <Foundation/Foundation.h>


@interface MCSourceListRegistry : NSObject {
    @private
    
	NSMutableArray*          _orderedSourceListTypes;
	
    NSMutableDictionary*     _sourceListTypeConfigs;
	
	NSMutableDictionary*     _defaultSourceLists;
}

+ (MCSourceListRegistry *)defaultInstance;


- (void)populateRegistryFromFileAtPath: (NSString*)path;


// Default Methods
- (void)registerDefaultSourceList: (NSDictionary*)aSourceList forVersion: (NSNumber*)aVersion;
- (void)registerDefaultSourceLists: (NSArray*)sourceLists;
- (NSArray*)defaultSourceListsForVersion: (NSNumber*)aVersion;
- (NSArray*)allDefaultSourceLists; // Returns all the default sourcelists for all versions

// Registration methods
- (void)registerSourceListTypeConfig: (NSDictionary *)aSourceListView;

// Lookup Methods
- (NSDictionary *)sourceListTypeConfigForType: (NSString*)aType;

- (void)registerSourceListTypeConfigs: (NSArray *)sourceListTypes;





// Accessors - debating if these should be private...
- (NSMutableDictionary *)defaultSourceLists;
- (void)setDefaultSourceLists:(NSMutableDictionary *)aDefaultSourceLists;


- (NSMutableDictionary *)sourceListTypeConfigs;
- (void)setSourceListTypeConfigs:(NSMutableDictionary *)aSourceListTypeConfigs;

- (NSMutableArray *)orderedSourceListTypes;
- (void)setOrderedSourceListTypes:(NSMutableArray *)anOrderedSourceListTypes;

@end
